/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

//  PXIView.h
//  PXIView
//
//  last changed by: creysoft

/* Declaration of PXIView

	This just imports our two card part classes.

*/

#import <Cocoa/Cocoa.h>
#import "PXIFileFormat.h"
#import "PXIButtonView.h"
#import "PXIFieldView.h"
#import "PXIPart.h"
#import "PXICodeMixer.h"

@interface PXIView : NSView {
	NSString * partName;
	NSTimer * eventTimer;
	
	NSMutableArray * cdPartCatalog;
	NSMutableArray * bgPartCatalog;
	
}

- (int)registerCardPart:(PXIPart*)whatPart;
- (void)unregisterCardPart:(PXIPart*)whatPart;
- (int)registerBackgroundPart:(PXIPart*)whatPart;
- (void)unregisterBackgroundPart:(PXIPart*)whatPart;
- (NSString *)partName;
- (void)setPartName:(NSString *)newPartname;

- (PXIPart *)getPartFromName:(NSString *)pName;
- (void)mixMaster;

@end
